<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/costanti.php";
    include "include/util.php";
    include "gUtil/DbManager.php";
    include "gUtil/SocialSharer.php";
    include "gUtil/ControlloreStringhe.php";
    include "gUtil/GestoreTraduzioni.php";
    include "template/stile.php";
    include "template/include/includeClassiTemplate.php";
    include "classi/GeneratoreUrl.php";
    include "classi/GestoreJavascript.php";

    //i dati del database sono definiti nel file costanti.php
    $geecomDb          = new DbManager($costantiDatabase);		
    $gestoreJavascript = new GestoreJavascript();
    $impostazioni      = recuperaImpostazioni($geecomDb);
    $configurazioneAspetto = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto","si","selezionataCms");
    $impostazioniEcommerce = $geecomDb->leggiSingolaRiga("geecEc_impostazioni",1);
    $inclusioni = recuperaInclusioni($geecomDb);
    $datiCookie = $geecomDb->leggiSingolaRiga("geecB_leggeCookie",1);
    $profiliSocial = $geecomDb->leggiSingolaRiga("geec_profiliSocial",1);
    
    // recupera lo stile scelto, la variabile aspettiSito è contenuta nel file stile.php
    $aspettoSito = $aspettiSito[$impostazioni["aspettoSito"]];
    
    
    //prende i dati dell'articolo
    $prodotto = $geecomDb->leggiSingolaRiga("geecEc_prodotti", filter_input(INPUT_GET,"alias",FILTER_SANITIZE_STRING),"alias");

    // se il prodotto non esiste viene mostrata la pagina non trovata
    if(!$prodotto) {
        unset($prodotto);
        include "template/include/paginaNonTrovata//index.php";
        exit();
    }
    
    $lingua   = $prodotto["lingua"];
    $gestoreTraduzioni = new GestoreTraduzioni("localizzazione", array($lingua));
    $gestoreTraduzioni->caricaTraduzioni();
    
    //incrementa il numero di visite, controlla è l'amministratore a visualizzare l'articolo, in questo caso
    //non lo incrementa
    session_start();
    if(!isset($_SESSION["geecomAdmin_email"])) {
        $dataVisualizzazione = date("Y-m-d");
        $queryAggiornamentoVisite = "UPDATE geecEc_prodotti SET numeroVisite=numeroVisite+1 WHERE id={$prodotto["id"]}";
        $geecomDb->eseguiQueryScrittura($queryAggiornamentoVisite);

        incrementaConteggioVisite($geecomDb,$dataVisualizzazione);
    }

    $gestoreJavascript->aggiungiLinkJavascript("<script src=\"template/js/owl.carousel.min.js\"></script>");
    $gestoreJavascript->aggiungiJavascript("<script>$('.prodotto-slider').owlCarousel({
                    loop:false,
                    margin:0,
                    nav:true,
                    responsive:{
                            0:{
                                    items:1
                            },
                            600:{
                                    items:1
                            },
                            1000:{
                                    items:1
                            }
                    }
            })
            </script>");
    
    if(isset($_SESSION["geecomUser_idGruppo"]) && $_SESSION["geecomUser_idGruppo"]!=0) {
	$datiGruppo = $geecomDb->leggiSingolaRiga("geecAd_gruppi",$_SESSION["geecomUser_idGruppo"]);
    }
    else {
	$datiGruppo = null;
    }
?>
<!DOCTYPE html>
<html lang="en">

    <head>
    <?php 
        echo $inclusioni["inizioHead"];
    ?>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" 
	<?php
            echo"content=\"{$prodotto["nome"]}\"";
	?>
    >
    <meta property="og:title" content="<?php echo $prodotto["nome"]; ?>">
    <meta property="og:description" content="<?php echo substr($prodotto["nome"],0,160) ?>">
    <meta property="og:image" content="<?php echo $impostazioni["urlSito"]."/".$prodotto["immagine"]; ?>"/>

    <title><?php echo("{$prodotto["nome"]}"); ?></title>

    <?php 
	 include "include/includeCssBase.php"; 

        echo $inclusioni["fineHead"];
    ?>
    </head>

    <body class="d-flex flex-column <?php echo $aspettoSito["body"]; ?> <?php echo(($impostazioni["attivaBarraSuperiore"]=="si") ? "extraspace" : ""); ?>">
    <!-- menu principale -->
    <?php
        echo $inclusioni["inizioBody"];

        if(isset($_SESSION["geecomAdmin_email"])) {
            include "template/include/barraAdmin.php";
        }
    
        if ($impostazioni["manutenzione"]=="si" && !isset($_SESSION["geecomAdmin_email"])) {            
            include "template/include/aspetto/{$aspettoSito["cartellaTemplatePagina"]}/templatePagina/manutenzione.php";
        }
        else {
            include "template/include/aspetto/{$aspettoSito["cartellaTemplatePagina"]}/templateProdotto/{$prodotto["template"]}";

            // contiene la modal sulla legge dei cookie, la ricerca fullscreen ed eventuali
            // aggiunte del tema
            include"template/include/elementiAggiuntiviTemplate.php";

            UtilTemplate::stampaScrollTop();
        }
        
        include "include/includeJsBase.php";

        echo $inclusioni["fineBody"];
    ?>
    
    </body>

</html>
